#####    Mia Daucourt   #####
#####   Meta-Analysis on the HME and Children's Math Achievement   #####
#####       May 2021      #####


# Set Working Directory
setwd("/Users/miadaucourt/Documents/R Data")

#load required packages
library(metafor)


##################### Bring in dataset ############################
dat1<- read.csv('Final HME Meta Codebook 052321.csv', header=TRUE, na.strings = ".")

# convert variables into numeric, characters, and factors, as needed
dat1$count <- as.numeric(dat1$count)
dat1$type <- as.factor(dat1$type)
dat1$study <- as.numeric(dat1$study)
dat1$title <- as.character(dat1$title)
dat1$year <- as.factor(dat1$year)
dat1$es_details <- as.character(dat1$es_details)
dat1$n <- as.numeric(dat1$n)
dat1$grade_new2 <- as.factor(dat1$grade_new2)
dat1$long_new <- as.factor(dat1$Long_new)
dat1$HME_comp_new <- as.factor(dat1$HME_comp_new)
dat1$math_dom_nospat <- as.factor(dat1$math_dom_nospat)
dat1$symbolic_nonsymbolic <- as.factor(dat1$symbolic_nonsymbolic)
dat1$timed_untimed <- as.factor(dat1$timed_untimed)
dat1$timed_new <- as.factor(dat1$timed_new)
dat1$composite <- as.factor(dat1$composite)
dat1$std_new <- as.factor(dat1$std_new)
dat1$hme_calc <- as.factor(dat1$hme_calc)
dat1$low_SES <- as.factor(dat1$low_SES)
dat1$hme_type_nocombo <- as.factor(dat1$hme_type_nocombo)
dat1$obs_pr <- as.factor(dat1$obs_pr)
dat1$age <- as.numeric(dat1$age)
dat1$parent_ed <- as.numeric(dat1$parent_ed)
dat1$authors <- as.character(dat1$authors)
dat1$authors_etal <- as.character(dat1$authors_etal)


#CALCULATE FISHER'S Z
##calculate z into new var "yi" and its variance into "vi"
Zcalc<-escalc(measure="ZCOR", ri=r, ni=n, data=dat1)
summary(Zcalc)

## Make Z calc dataset into a data frame so I can get n's for each moderator level
DF_Zcalc <-as.data.frame(Zcalc)


#### Model Fitting for Meta ES estimation

### regular random-effects model using rma.mv()
### note: sigma^2 in this model is the same as tau^2 from the model that doesn't control for dependencies
overall <- rma.mv(yi, vi, random = ~ 1|study/count, data=Zcalc, test="t")
summary(overall)

## robust variance estimation small-sample adjustment using sandwich-type estimator
robu_overall<-robust.rma.mv(overall, cluster=Zcalc$study, adjust = TRUE, test="t")
summary(robu_overall)




## Convert Z back to R for overall model
overall_r.back <- ((2.71828182845905^(2 *   0.1275)) - 1) / ((2.71828182845905^(2 *   0.1275)) + 1)
## Convert Z back to R for confidence interval (LCI = lower confidence interval, UCI = upper confidence interval)
r.backLCI <- ((2.71828182845905^(2 *   0.0869)) - 1) / ((2.71828182845905^(2 *   0.0869)) + 1)
r.backUCI <- ((2.71828182845905^(2 *   0.1681)) - 1) / ((2.71828182845905^(2 *   0.1681)) + 1)

## check values
overall_r.back # =  0.1268136
r.backLCI # = 0.08668191
r.backUCI # = 0.1665343



### calculate the distribution of variance over the 3 levels of our model

## calculate overall I-squared
W <- diag(1/Zcalc$vi)
X <- model.matrix(overall)
P <- W - W %*% X %*% solve(t(X) %*% W %*% X) %*% t(X) %*% W
100 * sum(overall$sigma2) / (sum(overall$sigma2) + (overall$k-overall$p)/sum(diag(P)))

## calculate I-squared for each level
100 * overall$sigma2 / (sum(overall$sigma2) + (overall$k-overall$p)/sum(diag(P)))

# calculate % heterogeneity due to sampling error
samp_var <- 100-(60.81013 + 34.33700)
samp_var



####### RUNNING MODERATOR ANALYSES ######################################

############### HME Assessment Characteristics

##### HME component

##### Omnibus test
## intercept = 1 (direct)
HMEcomp <- rma.mv(yi, vi, mods = ~ factor(HME_comp_new), random = ~ 1 | study/count, data=Zcalc, test="t")
summary(HMEcomp)
#robust variance estimation
rob_HMEcomp<-robust.rma.mv(HMEcomp, cluster = Zcalc$study, adjust=TRUE)
summary(rob_HMEcomp)


###### subgroup effect sizes
# direct
direct= subset (Zcalc, HME_comp_new==1)
hmecomp1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=direct, test="t", subset=(HME_comp_new==1))
robu_hmecomp1<-robust.rma.mv(hmecomp1, cluster=direct$study, adjust = TRUE)
summary(robu_hmecomp1)

#indirect
indirect= subset (Zcalc, HME_comp_new==2)
hmecomp2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=indirect, test="t", subset=(HME_comp_new==2))
robu_hmecomp2<-robust.rma.mv(hmecomp2, cluster=indirect$study, adjust = TRUE)
summary(robu_hmecomp2)

#direct and indirect
dir_indir= subset (Zcalc, HME_comp_new==3)
hmecomp3 <- rma.mv(yi, vi, random = ~ 1|study/count, data=dir_indir, test="t", subset=(HME_comp_new==3))
robu_hmecomp3<-robust.rma.mv(hmecomp3, cluster=dir_indir$study, adjust = TRUE)
summary(robu_hmecomp3)

#att/beliefs
att_beliefs= subset (Zcalc, HME_comp_new==4)
hmecomp4 <- rma.mv(yi, vi, random = ~ 1|study/count, data=att_beliefs, test="t", subset=(HME_comp_new==4))
robu_hmecomp4<-robust.rma.mv(hmecomp4, cluster=att_beliefs$study, adjust = TRUE)
summary(robu_hmecomp4)

#expectations
expect= subset (Zcalc, HME_comp_new==5)
hmecomp5 <- rma.mv(yi, vi, random = ~ 1|study/count, data=expect, test="t", subset=(HME_comp_new==5))
robu_hmecomp5<-robust.rma.mv(hmecomp5, cluster=expect$study, adjust = TRUE)
summary(robu_hmecomp5)

#spatial
spatial= subset (Zcalc, HME_comp_new==6)
hmecomp6 <- rma.mv(yi, vi, random = ~ 1|study/count, data=spatial, test="t", subset=(HME_comp_new==6))
robu_hmecomp6<-robust.rma.mv(hmecomp6, cluster=spatial$study, adjust = TRUE)
summary(robu_hmecomp6)

#math talk
math_talk= subset (Zcalc, HME_comp_new==7)
hmecomp7 <- rma.mv(yi, vi, random = ~ 1|study/count, data=math_talk, test="t", subset=(HME_comp_new==7))
robu_hmecomp7<-robust.rma.mv(hmecomp7, cluster=math_talk$study, adjust = TRUE)
summary(robu_hmecomp7)



## HME component moderator pairwise comparisons

#HME component: direct
# direct v indirect
hmecomp.1v2 <- ifelse(Zcalc$HME_comp_new == 1, 0, ifelse(Zcalc$HME_comp_new == 2, 1, NA)) 

dir_indir<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(hmecomp.1v2))
summary(dir_indir)
robu_dir_indir<-robust.rma.mv(dir_indir, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_indir)

# direct v direct/indirect
hmecomp.1v3 <- ifelse(Zcalc$HME_comp_new == 1, 0, ifelse(Zcalc$HME_comp_new == 3, 1, NA)) 

dir_dirindir<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                  mods=~factor(hmecomp.1v3))
summary(dir_dirindir)
robu_dir_dirindir<-robust.rma.mv(dir_dirindir, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_dirindir)


# direct v attitudes
hmecomp.1v4 <- ifelse(Zcalc$HME_comp_new == 1, 0, ifelse(Zcalc$HME_comp_new == 4, 1, NA)) 

dir_att<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                  mods=~factor(hmecomp.1v4))
summary(dir_att)
robu_dir_att<-robust.rma.mv(dir_att, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_att)


# direct v expectations
hmecomp.1v5 <- ifelse(Zcalc$HME_comp_new == 1, 0, ifelse(Zcalc$HME_comp_new == 5, 1, NA)) 

dir_expect<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                mods=~factor(hmecomp.1v5))
summary(dir_expect)
robu_dir_expect<-robust.rma.mv(dir_expect, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_expect)


# direct v spatial
hmecomp.1v6 <- ifelse(Zcalc$HME_comp_new == 1, 0, ifelse(Zcalc$HME_comp_new == 6, 1, NA)) 

dir_spatial<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                   mods=~factor(hmecomp.1v6))
summary(dir_spatial)
robu_dir_spatial<-robust.rma.mv(dir_spatial, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_spatial)


# direct v math talk
hmecomp.1v7 <- ifelse(Zcalc$HME_comp_new == 1, 0, ifelse(Zcalc$HME_comp_new == 7, 1, NA)) 

dir_talk<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(hmecomp.1v7))
summary(dir_talk)
robu_dir_talk<-robust.rma.mv(dir_talk, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_talk)



#HME component: indirect (2)
# indirect v direct/indirect
hmecomp.2v3 <- ifelse(Zcalc$HME_comp_new == 2, 0, ifelse(Zcalc$HME_comp_new == 3, 1, NA)) 

dir_indir_att<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                  mods=~factor(hmecomp.2v3))
summary(dir_indir_att)
robu_dir_indir_att<-robust.rma.mv(dir_indir_att, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_indir_att)

# indirect v attitudes
hmecomp.2v4 <- ifelse(Zcalc$HME_comp_new == 2, 0, ifelse(Zcalc$HME_comp_new == 4, 1, NA)) 

indir_att<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                mods=~factor(hmecomp.2v4))
summary(indir_att)
robu_indir_att<-robust.rma.mv(indir_att, cluster=Zcalc$study, adjust = TRUE)
summary(robu_indir_att)


# indirect v expectations
hmecomp.2v5 <- ifelse(Zcalc$HME_comp_new == 2, 0, ifelse(Zcalc$HME_comp_new == 5, 1, NA)) 

indir_expect<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                   mods=~factor(hmecomp.2v5))
summary(indir_expect)
robu_indir_expect<-robust.rma.mv(indir_expect, cluster=Zcalc$study, adjust = TRUE)
summary(robu_indir_expect)


# indirect v spatial
hmecomp.2v6 <- ifelse(Zcalc$HME_comp_new == 2, 0, ifelse(Zcalc$HME_comp_new == 6, 1, NA)) 

indir_spatial<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(hmecomp.2v6))
summary(indir_spatial)
robu_indir_spatial<-robust.rma.mv(indir_spatial, cluster=Zcalc$study, adjust = TRUE)
summary(robu_indir_spatial)


# indirect v math talk
hmecomp.2v7 <- ifelse(Zcalc$HME_comp_new == 2, 0, ifelse(Zcalc$HME_comp_new == 7, 1, NA)) 

indir_talk<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                 mods=~factor(hmecomp.2v7))
summary(indir_talk)
robu_indir_talk<-robust.rma.mv(indir_talk, cluster=Zcalc$study, adjust = TRUE)
summary(robu_indir_talk)


#HME component: direct/indirect (3)

# direct/indirect v attitudes
hmecomp.3v4 <- ifelse(Zcalc$HME_comp_new == 3, 0, ifelse(Zcalc$HME_comp_new == 4, 1, NA)) 

dir_indir_att<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                  mods=~factor(hmecomp.3v4))
summary(dir_indir_att)
robu_dir_indir_att<-robust.rma.mv(dir_indir_att, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_indir_att)



# direct/indirect v expectations
hmecomp.3v5 <- ifelse(Zcalc$HME_comp_new == 3, 0, ifelse(Zcalc$HME_comp_new == 5, 1, NA)) 

dir_indir_expect<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                     mods=~factor(hmecomp.3v5))
summary(dir_indir_expect)
robu_dir_indir_expect<-robust.rma.mv(dir_indir_expect, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_indir_expect)


# direct/indirect v spatial
hmecomp.3v6 <- ifelse(Zcalc$HME_comp_new == 3, 0, ifelse(Zcalc$HME_comp_new == 6, 1, NA)) 

dir_indir_spat<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                         mods=~factor(hmecomp.3v6))
summary(dir_indir_spat)
robu_dir_indir_spat<-robust.rma.mv(dir_indir_spat, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_indir_spat)


# direct/indirect v math talk
hmecomp.3v7 <- ifelse(Zcalc$HME_comp_new == 3, 0, ifelse(Zcalc$HME_comp_new == 7, 1, NA)) 

dir_indir_talk<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                       mods=~factor(hmecomp.3v7))
summary(dir_indir_talk)
robu_dir_indir_talk<-robust.rma.mv(dir_indir_talk, cluster=Zcalc$study, adjust = TRUE)
summary(robu_dir_indir_talk)




#HME component: attitudes (4)

# attitudes v expectations
hmecomp.4v5 <- ifelse(Zcalc$HME_comp_new == 4, 0, ifelse(Zcalc$HME_comp_new == 5, 1, NA)) 

att_expect<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                     mods=~factor(hmecomp.4v5))
summary(att_expect)
robu_att_expect<-robust.rma.mv(att_expect, cluster=Zcalc$study, adjust = TRUE)
summary(robu_att_expect)


# attitudes v spatial
hmecomp.4v6 <- ifelse(Zcalc$HME_comp_new == 4, 0, ifelse(Zcalc$HME_comp_new == 6, 1, NA)) 

att_spatial<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                      mods=~factor(hmecomp.4v6))
summary(att_spatial)
robu_att_spatial<-robust.rma.mv(att_spatial, cluster=Zcalc$study, adjust = TRUE)
summary(robu_att_spatial)


# attitudes v math talk
hmecomp.4v7 <- ifelse(Zcalc$HME_comp_new == 4, 0, ifelse(Zcalc$HME_comp_new == 7, 1, NA)) 

att_talk<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                   mods=~factor(hmecomp.4v7))
summary(att_talk)
robu_att_talk<-robust.rma.mv(att_talk, cluster=Zcalc$study, adjust = TRUE)
summary(robu_att_talk)


#HME component: expectations (5)

# expectations v spatial
hmecomp.5v6 <- ifelse(Zcalc$HME_comp_new == 5, 0, ifelse(Zcalc$HME_comp_new == 6, 1, NA)) 

expect_spatial<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(hmecomp.5v6))
summary(expect_spatial)
robu_expect_spatial<-robust.rma.mv(expect_spatial, cluster=Zcalc$study, adjust = TRUE)
summary(robu_expect_spatial)


# expectations v math talk
hmecomp.5v7 <- ifelse(Zcalc$HME_comp_new == 5, 0, ifelse(Zcalc$HME_comp_new == 7, 1, NA)) 

expect_talk<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                 mods=~factor(hmecomp.5v7))
summary(expect_talk)
robu_expect_talk<-robust.rma.mv(expect_talk, cluster=Zcalc$study, adjust = TRUE)
summary(robu_expect_talk)


#HME component: spatial (6)

# spatial v math talk
hmecomp.6v7 <- ifelse(Zcalc$HME_comp_new == 6, 0, ifelse(Zcalc$HME_comp_new == 7, 1, NA)) 

spatial_talk<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(hmecomp.6v7))
summary(spatial_talk)
robu_spatial_talk<-robust.rma.mv(spatial_talk, cluster=Zcalc$study, adjust = TRUE)
summary(robu_spatial_talk)






## HME measurement method

## omnibus test, 1 = frequency-based scale
Model_HME_type <- rma.mv(yi, vi, mods = ~ factor(hme_type_nocombo), random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model_HME_type)
robu_hmetype<-robust.rma.mv(Model_HME_type, cluster=Zcalc$study, adjust = TRUE)
summary(robu_hmetype)

###### subgroup effect sizes

#frequency-based scale
freq= subset (Zcalc, hme_type_nocombo==1)
hmetype1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=freq, test="t")
robu_hmetype1<-robust.rma.mv(hmetype1, cluster=freq$study, adjust = TRUE)
summary(robu_hmetype1)

#rating scale
rating= subset (Zcalc, hme_type_nocombo==2)
hmetype2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=rating, test="t")
robu_hmetype2<-robust.rma.mv(hmetype2, cluster=rating$study, adjust = TRUE)
summary(robu_hmetype2)

#checklist
checklist= subset (Zcalc, hme_type_nocombo==3)
hmetype3 <- rma.mv(yi, vi, random = ~ 1|study/count, data=checklist, test="t")
robu_hmetype3<-robust.rma.mv(hmetype3, cluster=checklist$study, adjust = TRUE)
summary(robu_hmetype3)

#observation
obs= subset (Zcalc, hme_type_nocombo==4)
hmetype4 <- rma.mv(yi, vi, random = ~ 1|study/count, data=obs, test="t")
robu_hmetype4<-robust.rma.mv(hmetype4, cluster=obs$study, adjust = TRUE)
summary(robu_hmetype4)



## pairwise comparisons

#HME Type Frequency-Based Scale (1)
# frequency-based scale v. rating scale
hmetype.1v2 <- ifelse(Zcalc$hme_type_nocombo == 1, 0, ifelse(Zcalc$hme_type_nocombo == 2, 1, NA)) 

freq_rating<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(hmetype.1v2))
summary(freq_rating)
robu_freqrating<-robust.rma.mv(freq_rating, cluster=Zcalc$study, adjust = TRUE)
summary(robu_freqrating)

# frequency-based scale v checklist
hmetype.1v3 <- ifelse(Zcalc$hme_type_nocombo == 1, 0, ifelse(Zcalc$hme_type_nocombo == 3, 1, NA)) 

freq_check<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                   mods=~factor(hmetype.1v3))
summary(freq_check)
robu_freq_check<-robust.rma.mv(freq_check, cluster=Zcalc$study, adjust = TRUE)
summary(robu_freq_check)

# frequency-based scale v observation
hmetype.1v4 <- ifelse(Zcalc$hme_type_nocombo == 1, 0, ifelse(Zcalc$hme_type_nocombo == 4, 1, NA)) 

freq_obs<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                 mods=~factor(hmetype.1v4))
summary(freq_obs)
robu_freq_obs<-robust.rma.mv(freq_obs, cluster=Zcalc$study, adjust = TRUE)
summary(robu_freq_obs)


#HME Type: Rating Scale (2)
## rating v checklist
hmetype.2v3 <- ifelse(Zcalc$hme_type_nocombo == 2, 0, ifelse(Zcalc$hme_type_nocombo == 3, 1, NA)) 

rating_check<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                     mods=~factor(hmetype.2v3))
summary(rating_check)
robu_rating_check<-robust.rma.mv(rating_check, cluster=Zcalc$study, adjust = TRUE)
summary(robu_rating_check)

## rating scale v observation
hmetype.2v4 <- ifelse(Zcalc$hme_type_nocombo == 2, 0, ifelse(Zcalc$hme_type_nocombo == 4, 1, NA)) 

rating_obs<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                   mods=~factor(hmetype.2v4))
summary(rating_obs)
robu_rating_obs<-robust.rma.mv(rating_obs, cluster=Zcalc$study, adjust = TRUE)
summary(robu_rating_obs)


#HME Type Checklist (3)
## checklist v observation
hmetype.3v4 <- ifelse(Zcalc$hme_type_nocombo == 3, 0, ifelse(Zcalc$hme_type_nocombo == 4, 1, NA)) 

check_obs<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                  mods=~factor(hmetype.3v4))
summary(check_obs)
robu_check_obs<-robust.rma.mv(check_obs, cluster=Zcalc$study, adjust = TRUE)
summary(robu_check_obs)






## HME measurement method new: observation vs. parent-report only (obs_pr)
obs_parrep <- rma.mv(yi, vi, mods = ~ factor(obs_pr), random = ~ 1 | study/count, data=Zcalc, 
                     test="t", struct="DIAG")
summary(obs_parrep)
rob_obs_parrep<-robust.rma.mv(obs_parrep, cluster = Zcalc$study, adjust=TRUE)
summary(rob_obs_parrep)

###### subgroup effect sizes

## 1 = questionnaire/parent-report
observation= subset (Zcalc, obs_pr==1)
obs_pr1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=observation, test="t")
summary(obs_pr1)
robu_obs_pr1<-robust.rma.mv(obs_pr1, cluster=observation$study, adjust = TRUE)
summary(robu_obs_pr1)

## 2 = observation
par_rep= subset (Zcalc, obs_pr==2)
obs_pr2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=par_rep, test="t")
summary(obs_pr2)
robu_obs_pr2<-robust.rma.mv(obs_pr2, cluster=par_rep$study, adjust = TRUE)
summary(robu_obs_pr2)





###### MODERATOR 3
## HME score calculation method

## omnibus test, 1 = latent factor
Model_HME_calc <- rma.mv(yi, vi, mods = ~ factor(hme_calc), random = ~ 1 | study/count, data=Zcalc, test="t", struct="DIAG")
summary(Model_HME_calc)
robu_hmecalc<-robust.rma.mv(Model_HME_calc, cluster=Zcalc$study, adjust = TRUE)
summary(robu_hmecalc)


###### subgroup effect sizes

## latent factor
latent= subset (Zcalc, hme_calc==1)
hmecalc1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=latent, test="t")
robu_hmecalc1<-robust.rma.mv(hmecalc1, cluster=latent$study, adjust = TRUE)
summary(robu_hmecalc1)

## sum score
sumsc= subset (Zcalc, hme_calc==2)
hmecalc2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=sumsc, test="t")
robu_hmecalc2<-robust.rma.mv(hmecalc2, cluster=sumsc$study, adjust = TRUE)
summary(robu_hmecalc2)

## single item
single= subset (Zcalc, hme_calc==3)
hmecalc3 <- rma.mv(yi, vi, random = ~ 1|study/count, data=single, test="t")
robu_hmecalc3<-robust.rma.mv(hmecalc3, cluster=single$study, adjust = TRUE)
summary(robu_hmecalc3)






################## Math Assessment characteristics
###### MODERATOR 4 
###### MATH DOMAIN (math_domain_nospat)

## with intercept
Model2_mathdom_nospat <- rma.mv(yi, vi, mods = ~ relevel(factor(math_dom_nospat), ref="3"), random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model2_mathdom_nospat)
robu_mathdom_nospat<-robust.rma.mv(Model2_mathdom_nospat, cluster=Zcalc$study, adjust = TRUE)
summary(robu_mathdom_nospat)


## separate subgroup estimates
# arithmetic operations
arithmetic_ops= subset (Zcalc, math_dom_nospat==1)
mathdom1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=arithmetic_ops, test="t")
robu_mathdom1<-robust.rma.mv(mathdom1, cluster=arithmetic_ops$study, adjust = TRUE)
summary(robu_mathdom1)

# relations
relations= subset (Zcalc, math_dom_nospat==2)
mathdom2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=relations, test="t")
robu_mathdom2<-robust.rma.mv(mathdom2, cluster=relations$study, adjust = TRUE)
summary(robu_mathdom2)

# numbering
numbering= subset (Zcalc, math_dom_nospat==3)
mathdom3 <- rma.mv(yi, vi, random = ~ 1|study/count, data=numbering, test="t")
robu_mathdom3<-robust.rma.mv(mathdom3, cluster=numbering$study, adjust = TRUE)
summary(robu_mathdom3)

# multiple
multiple= subset (Zcalc, math_dom_nospat==4)
mathdom4 <- rma.mv(yi, vi, random = ~ 1|study/count, data=multiple, test="t")
robu_mathdom4<-robust.rma.mv(mathdom4, cluster=multiple$study, adjust = TRUE)
summary(robu_mathdom4)


#### pairwise comparisons #####

# arithmetic operations v relations
mathdomain.1v2 <- ifelse(Zcalc$math_dom_nospat == 1, 0, ifelse(Zcalc$math_dom_nospat == 2, 1, NA)) 
arith_relat<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                   mods=~factor(mathdomain.1v2))
summary(arith_relat)
robu_arith_relat<-robust.rma.mv(arith_relat, cluster=Zcalc$study, adjust = TRUE)
summary(robu_arith_relat)


# arithmetic operations v numbering
mathdomain.1v3 <- ifelse(Zcalc$math_dom_nospat == 1, 0, ifelse(Zcalc$math_dom_nospat == 3, 1, NA)) 
arith_numb<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(mathdomain.1v3))
summary(arith_numb)
robu_arith_numb<-robust.rma.mv(arith_numb, cluster=Zcalc$study, adjust = TRUE)
summary(robu_arith_numb)


# arithmetic operations v multiple
mathdomain.1v4 <- ifelse(Zcalc$math_dom_nospat == 1, 0, ifelse(Zcalc$math_dom_nospat == 4, 1, NA)) 
arith_multi<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                      mods=~factor(mathdomain.1v4))
summary(arith_multi)
robu_arith_multi<-robust.rma.mv(arith_multi, cluster=Zcalc$study, adjust = TRUE)
summary(robu_arith_multi)


#Math Domain - Relations (2)
# relations v numbering
mathdomain.2v3 <- ifelse(Zcalc$math_dom_nospat == 2, 0, ifelse(Zcalc$math_dom_nospat == 3, 1, NA)) 
relat_numb<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                   mods=~factor(mathdomain.2v3))
summary(relat_numb)
robu_relat_numb<-robust.rma.mv(relat_numb, cluster=Zcalc$study, adjust = TRUE)
summary(robu_relat_numb)

# relations v multiple
mathdomain.2v4 <- ifelse(Zcalc$math_dom_nospat == 2, 0, ifelse(Zcalc$math_dom_nospat == 4, 1, NA)) 
relat_multi<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(mathdomain.2v4))
summary(relat_multi)
robu_relat_multi<-robust.rma.mv(relat_multi, cluster=Zcalc$study, adjust = TRUE)
summary(robu_relat_multi)


#Math Domain- Numbering (4)
# numbering v multiple
mathdomain.3v4 <- ifelse(Zcalc$math_dom_nospat == 3, 0, ifelse(Zcalc$math_dom_nospat == 4, 1, NA)) 
numb_multi<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(mathdomain.3v4))
summary(numb_multi)
robu_numb_multi<-robust.rma.mv(numb_multi, cluster=Zcalc$study, adjust = TRUE)
summary(robu_numb_multi)





###### SYMBOLIC

##overall omnibus (1=symbolic as reference group)
Model2_symb <- rma.mv(yi, vi, mods = ~ factor(symbolic_nonsymbolic), random = ~ 1 | study/count, data=Zcalc, 
                      test="t")
summary(Model2_symb)
robu_symb<-robust.rma.mv(Model2_symb, cluster=Zcalc$study, adjust = TRUE)
summary(robu_symb)

## separate subgroup estimates

#symbolic
symbolic= subset (Zcalc, symbolic_nonsymbolic==1)
symbolic1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=symbolic, test="t")
robu_symbolic1<-robust.rma.mv(symbolic1, cluster=symbolic$study, adjust = TRUE)
summary(robu_symbolic1)

#non-symbolic
nonsymbolic= subset (Zcalc, symbolic_nonsymbolic==2)
symbolic2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=nonsymbolic, test="t")
robu_symbolic2<-robust.rma.mv(symbolic2, cluster=nonsymbolic$study, adjust = TRUE)
summary(robu_symbolic2)

#symbolic/nonsymbolic
symbnonsymb= subset (Zcalc, symbolic_nonsymbolic==3)
symbolic3 <- rma.mv(yi, vi, random = ~ 1|study/count, data=symbnonsymb, test="t")
robu_symbolic3<-robust.rma.mv(symbolic3, cluster=symbnonsymb$study, adjust = TRUE)
summary(robu_symbolic3)


## pairwise comparisons

#Symbolic (1)
# symbolic v nonsymbolic
symbolic.1v2 <- ifelse(Zcalc$symbolic_nonsymbolic == 1, 0, ifelse(Zcalc$symbolic_nonsymbolic == 2, 1, NA)) 
symb_nonsymb<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                    mods=~factor(symbolic.1v2))
summary(symb_nonsymb)
robu_symb_nonsymb<-robust.rma.mv(symb_nonsymb, cluster=Zcalc$study, adjust = TRUE)
summary(robu_symb_nonsymb)

# symbolic v combination
symbolic.1v3 <- ifelse(Zcalc$symbolic_nonsymbolic == 1, 0, ifelse(Zcalc$symbolic_nonsymbolic == 3, 1, NA)) 
symb_combo<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                     mods=~factor(symbolic.1v3))
summary(symb_combo)
robu_symb_combo<-robust.rma.mv(symb_combo, cluster=Zcalc$study, adjust = TRUE)
summary(robu_symb_combo)

#Nonsymbolic (2)
# nonsymbolic v combination
symbolic.2v3 <- ifelse(Zcalc$symbolic_nonsymbolic == 2, 0, ifelse(Zcalc$symbolic_nonsymbolic == 3, 1, NA)) 
nonsymb_combo<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                   mods=~factor(symbolic.2v3))
summary(nonsymb_combo)
robu_nonsymb_combo<-robust.rma.mv(nonsymb_combo, cluster=Zcalc$study, adjust = TRUE)
summary(robu_nonsymb_combo)





######## COMPOSITE

## omnibus test with intercept, 1 = composite
Model2_comp <- rma.mv(yi, vi, mods = ~ factor(composite), random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model2_comp)
robu_comp<-robust.rma.mv(Model2_comp, cluster=Zcalc$study, adjust = TRUE)
summary(robu_comp)

## separate subgroup estimates

#composite
comp= subset (Zcalc, composite==1)
comp1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=comp, test="t")
robu_comp1<-robust.rma.mv(comp1, cluster=comp$study, adjust = TRUE)
summary(robu_comp1)

#single
single= subset (Zcalc, composite==2)
comp2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=single, test="t")
robu_comp2<-robust.rma.mv(comp2, cluster=single$study, adjust = TRUE)
summary(robu_comp2)

## pairwise comparison: composite vs. single assessment
composite.1v2 <- ifelse(Zcalc$composite == 1, 0, ifelse(Zcalc$composite == 2, 1, NA)) 
comp_single<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                  mods=~factor(composite.1v2))
summary(comp_single)
robu_comp_single<-robust.rma.mv(comp_single, cluster=Zcalc$study, adjust = TRUE)
summary(robu_comp_single)




####### STANDARDIZED

## omnibus test with intercept, 1=standardized
Model2_stdized <- rma.mv(yi, vi, mods = ~ factor(std_new), random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model2_stdized)
robu_std<-robust.rma.mv(Model2_stdized, cluster=Zcalc$study, adjust = TRUE)
summary(robu_std)


## separate subgroup estimates

#standardized
std= subset (Zcalc, std_new==1)
stand1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=std, test="t")
robu_std1<-robust.rma.mv(stand1, cluster=std$study, adjust = TRUE)
summary(robu_std1)

#unstandardized
unstd= subset (Zcalc, std_new==2)
stand2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=unstd, test="t")
robu_std2<-robust.rma.mv(stand2, cluster=unstd$study, adjust = TRUE)
summary(robu_std2)


## pairwise comparison
# standardized v unstandardized
std.1v2 <- ifelse(Zcalc$std_new == 1, 0, ifelse(Zcalc$std_new == 2, 1, NA)) 
std_unstd<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                        mods=~factor(std.1v2))
summary(std_unstd)
robu_std_unstd<-robust.rma.mv(std_unstd, cluster=Zcalc$study, adjust = TRUE)
summary(robu_std_unstd)




### LONGITUDINAL


## overall omnibus test
Model2_long <- rma.mv(yi, vi, mods = ~ factor(long_new), random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model2_long)
robu_long<-robust.rma.mv(Model2_long, cluster=Zcalc$study, adjust = TRUE)
summary(robu_long)


## separate subgroup estimates

#longitudinal
long= subset (Zcalc, longitudinal==1)
long1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=long, test="t")
robu_long1<-robust.rma.mv(long1, cluster=long$study, adjust = TRUE)
summary(robu_long1)

#concurrent
conc= subset (Zcalc, longitudinal==2)
long2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=conc, test="t")
robu_long2<-robust.rma.mv(long2, cluster=conc$study, adjust = TRUE)
summary(robu_long2)


## pairwise comparison

#Longitudinal (1)
# longitudinal v concurrent
long.1v2 <- ifelse(Zcalc$long_new == 1, 0, ifelse(Zcalc$long_new == 2, 1, NA)) 
long_concurrent<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                  mods=~factor(long.1v2))
summary(long_concurrent)
robu_long_concurrent<-robust.rma.mv(long_concurrent, cluster=Zcalc$study, adjust = TRUE)
summary(robu_long_concurrent)




################## Sample Characteristics

##### AGE

## overal omnibus test
Model2_age <- rma.mv(yi, vi, mods = ~ age, random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model2_age)
robu_age<-robust.rma.mv(Model2_age, cluster=Zcalc$study, adjust = TRUE)
summary(robu_age)




###### GRADE (grade_new2) #1 = PK/KG, 2 = primary and secondary
## overall omnibus test
Model_gradenew2 <- rma.mv(yi, vi, mods = ~ factor(grade_new2), random = ~ 1|study/count, data=Zcalc, test="t")
summary(Model_gradenew2)
robu_model_gradenew2<-robust.rma.mv(Model_gradenew2, cluster=Zcalc$study, adjust = TRUE)
summary(robu_model_gradenew2)


## separate subgroup estimates

#PK/KG
pk_kg= subset (Zcalc, grade_new2==1)
gradenew1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=pk_kg, test="t")
robu_gradenew1<-robust.rma.mv(gradenew1, cluster=pk_kg$study, adjust = TRUE)
summary(robu_gradenew1)


#Primary & Secondary
primary= subset (Zcalc, grade_new2==2)
gradenew2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=primary, test="t")
robu_gradenew2<-robust.rma.mv(gradenew2, cluster=primary$study, adjust = TRUE)
summary(robu_gradenew2)


# pk/kg vs. primary/secondary
grade.1v2 <- ifelse(Zcalc$grade_new2 == 1, 0, ifelse(Zcalc$grade_new2 == 2, 1, NA)) 
pk_older<-rma.mv(yi=yi, V=vi, data=Zcalc, random = ~ 1 | study/count, 
                        mods=~factor(grade.1v2))
summary(pk_older)
robu_pk_older<-robust.rma.mv(pk_older, cluster=Zcalc$study, adjust = TRUE)
summary(robu_pk_older)



######## Socioeconomic status (SES)

## omnibus test
Model2_SES <- rma.mv(yi, vi, mods = ~ factor(low_SES), random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model2_SES)
robu_ses<-robust.rma.mv(Model2_SES, cluster=Zcalc$study, adjust = TRUE)
summary(robu_ses)


## separate subgroup estimates

#low ses
lowses= subset (Zcalc, low_SES==1)
ses1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=lowses, test="t")
robu_ses1<-robust.rma.mv(ses1, cluster=lowses$study, adjust = TRUE)
summary(robu_ses1)

#avg ses
avgses= subset (Zcalc, low_SES==2)
ses2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=avgses, test="t")
robu_ses2<-robust.rma.mv(ses2, cluster=avgses$study, adjust = TRUE)
summary(robu_ses2)

#high ses
highses= subset (Zcalc, low_SES==3)
ses3 <- rma.mv(yi, vi, random = ~ 1|study/count, data=highses, test="t")
robu_ses3<-robust.rma.mv(ses3, cluster=highses$study, adjust = TRUE)
summary(robu_ses3)



####### PARENT EDUCATION

Model2_ed <- rma.mv(yi, vi, mods = ~ parent_ed, random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model2_ed)
robu_parented<-robust.rma.mv(Model2_ed, cluster=Zcalc$study, adjust = TRUE)
summary(robu_parented)



##### ##### ##### ##### ##### ##### ##### ##### ##### ##### ##### ##### ##### ##### ##### ##### ##### ##### 

############### Interactions ###############

## Age x HME component interaction

## center age variable first

age_centered<-scale(Zcalc$age, center = TRUE, scale = FALSE)


res_age_hme <- rma.mv(yi, vi, mods = ~ (age_centered*factor(HME_comp_new)),
                      random = ~ 1 | study/count, data=Zcalc, test="t")
summary(res_age_hme)
robu_age_hme<-robust.rma.mv(res_age_hme, cluster=Zcalc$study, adjust = TRUE)
summary(robu_age_hme)



### grade x hme component interaction
res_grade_hme <- rma.mv(yi, vi, mods = ~ (grade_new2*factor(HME_comp_new)),
                            random = ~ 1 | study/count, data=Zcalc, test="t")
summary(res_grade_hme)
robu_res_grade_hme<-robust.rma.mv(res_grade_hme, cluster=Zcalc$study, adjust = TRUE)
summary(robu_res_grade_hme)



## age x math domain interaction
res_age_mathdom <- rma.mv(yi, vi, mods = ~ (age_centered*factor(math_dom_nospat)),
                      random = ~ 1 | study/count, data=Zcalc, test="t")
summary(res_age_mathdom)
robu_res_age_mathdom<-robust.rma.mv(res_age_mathdom, cluster=Zcalc$study, adjust = TRUE)
summary(robu_res_age_mathdom)




## age x longitudinal interaction
res_age_long <- rma.mv(yi, vi, mods = ~ (age_centered*factor(long_new)),
                          random = ~ 1 | study/count, data=Zcalc, test="t")
summary(res_age_long)
robu_res_age_long<-robust.rma.mv(res_age_long, cluster=Zcalc$study, adjust = TRUE)
summary(robu_res_age_long)



## HME component x math domain interaction
res_hme_dom <- rma.mv(yi, vi, mods = ~ factor(math_dom_nospat)*factor(HME_comp_new),
                      random = ~ 1 | study/count, data=Zcalc, test="t", struct="DIAG")
summary(res_hme_dom)
robu_hme_dom<-robust.rma.mv(res_hme_dom, cluster=Zcalc$study, adjust = TRUE)
summary(robu_hme_dom)



#HME x symbolic interaction
res_hme_symb <- rma.mv(yi, vi, mods = ~ factor(symbolic_nonsymbolic)*factor(HME_comp_new),
                        random = ~ 1 | study/count, data=Zcalc, test="t", struct="DIAG")
summary(res_hme_symb)
robu_res_hme_symb<-robust.rma.mv(res_hme_symb, cluster=Zcalc$study, adjust = TRUE)
summary(robu_res_hme_symb)




## HME x SES interaction
res_hme_ses <- rma.mv(yi, vi, mods = ~ factor(low_SES)*factor(HME_comp_new),
                      random = ~ 1 | study/count, data=Zcalc, test="t", struct="DIAG")
summary(res_hme_ses)
robu_res_hme_ses<-robust.rma.mv(res_hme_ses, cluster=Zcalc$study, adjust = TRUE)
summary(robu_res_hme_ses)



########### ALL MODS AT ONCE #####################
full <- rma.mv(yi, vi, mods = ~ factor(grade_category) + factor(hne_comp_recode) + factor(hme_calc) 
               + factor(hme_type) + factor(timed_untimed), random = ~ 1|study/count, data=Zcalc, test="t")
summary(full)




##### PUBLICATION BIAS ANALYSES

########### Enhanced funnel plot of multilevel object  ###############################
funnel(overall, level=c(90, 95, 99), shade=c("white", "gray", "darkgray"), at = .13, refline=0.13)

################################## EGGER'S TEST ##################################
# Egger's test using multi-level data

eggers_multi <- rma.mv(yi, vi, random = ~ 1|study/count, mods=~(I(1/n)), data=Zcalc, test="t")
summary(eggers_multi)

######################## TYPE moderator to check for pub bias ##############################
summary(DF_Zcalc$type)

# omnibus test
Model2_type <- rma.mv(yi, vi, mods = ~ factor(type), random = ~ 1 | study/count, data=Zcalc, test="t")
summary(Model2_type)
robu_Model2_type<-robust.rma.mv(Model2_type, cluster=Zcalc$study, adjust = TRUE)
summary(robu_Model2_type)


#separate subgroup estimates
pub= subset (Zcalc, type==1)
type1 <- rma.mv(yi, vi, random = ~ 1|study/count, data=pub, test="t")
robu_type1<-robust.rma.mv(type1, cluster=pub$study, adjust = TRUE)
summary(robu_type1)

diss= subset (Zcalc, type==2)
type2 <- rma.mv(yi, vi, random = ~ 1|study/count, data=diss, test="t")
robu_type2<-robust.rma.mv(type2, cluster=diss$study, adjust = TRUE)
summary(robu_type2)

rvw= subset (Zcalc, type==3)
type3 <- rma.mv(yi, vi, random = ~ 1|study/count, data=rvw, test="t")
robu_type3<-robust.rma.mv(type3, cluster=rvw$study, adjust = TRUE)
summary(robu_type3)

################################## GET VALUES FOR P-CURVE ANALYSIS ##################################
##get z value for pcurve analysis by droping"test=t"
res_Z <- rma.mv(yi, vi, random = ~ 1 | study/count, data=Zcalc)
summary(res_Z)


################################## FAIL SAFE N ##################################
#FSN_Rosenberg <- fsn(z, vi., data= datt, type="Rosenberg", alpha=.05, subset, digits=4)
#FSN_Rosenberg

## this is the one Jamie used!
FSN_Rosenthal <- fsn(yi, vi, data= Zcalc, type="Rosenthal", alpha=.05, subset, digits=4)
FSN_Rosenthal

FSN_Rosenthal <- fsn(yi, vi, data= Zcalc, type="Rosenthal", alpha=.01, subset, digits=4)
FSN_Rosenthal
